﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias"
    xmlns:isoold="http://www.ascc.net/xml/schematron"
    xmlns:iso="http://purl.oclc.org/dsdl/schematron"
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:fn="http://www.w3.org/2005/xpath-functions"
    xmlns:tns="http://www.ato.gov.au/schemas"
    xmlns:regexp="http://www.blah.com"
    xmlns:function="http://ato.gov.au/SWSFunctions"
    
xmlns:xbrldi="http://xbrl.org/2006/xbrldi"
xmlns:xbrli="http://www.xbrl.org/2003/instance"
xmlns:xlink="http://www.w3.org/1999/xlink"
    version="2.0"
	>

  <!--xmlns:regexp="http://www.blah.com"
    xmlns:fn="http://www.w3.org/2005/xpath-functions"-->

  <!--<xsl:function name="function:IsDuration" as="xs:boolean"  >
    <xsl:param name="value" as="item()"/>
    <xsl:sequence select="$value/xbrli:period/xbrli:startDate and $value/xbrli:period/xbrli:endDate "/>
  </xsl:function>
  
  <xsl:function name="function:FindContext" as="item()"  >
    <xsl:param name="value" as="item()"/>
    <xsl:sequence select="$value/xbrli:xbrl/xbrli:context"/>
  </xsl:function>
  
  <xsl:function name="function:CountOfExplicitMembersEquals" as="xs:boolean"  >
    <xsl:param name="value" as="item()"/>
    <xsl:param name="count" as="xs:integer"/>
    <xsl:sequence select="$value/xbrli:entity/xbrli:segment[count(./xbrldi:explicitMember) = $count] "/>
  </xsl:function>
  
  <xsl:function name="function:ContainsExplicitMember" as="xs:boolean"  >
    <xsl:param name="value" as="item()"/>
    <xsl:param name="dimensionName" as="xs:string"/>
    <xsl:param name="domainMemberName" as="xs:string"/>
    <xsl:sequence select="$value/xbrli:entity/xbrli:segment/xbrldi:explicitMember [ matches(@dimension,'^.*:$dimensionName$') and matches(.,'^.*:$domainMemberName$') ] 	 "/>
  </xsl:function>-->

  <!-- ========================================================================
         function : ContainsCharSet
		   ========================================================================
		   Description																																
		     This function will find if any character in the set is within the value.       
		   ========================================================================																						
	       Input Parameters		
			  <xsl:param name="value" as="xs:string"/>
			  <xsl:param name="charSet" as="xs:string"/>
		   ========================================================================
    	   Output 																																	
	 	      true if char is found in value, false otherwise
		   ======================================================================== -->

  <xsl:function name="function:ContainsCharSet" as="xs:boolean"  >
    <xsl:param name="value" as="xs:string"/>
    <xsl:param name="charSet" as="xs:string"/>
    <xsl:sequence select="matches($value, $charSet)"/>
  </xsl:function>

  <!-- ========================================================================
         function : Contains 
		   ========================================================================
		   Description																																
		     This function will find if the Word parameter is within the value.       
		   ========================================================================																						
	       Input Parameters		
			  <xsl:param name="value" as="xs:string"/>
			  <xsl:param name="word" as="xs:string"/>
		   ========================================================================
    	   Output 																																	
	 	      true if word is found in value, false otherwise
		   ======================================================================== -->

  <xsl:function name="function:Contains" as="xs:boolean"  >
    <xsl:param name="value" as="xs:string"/>
    <xsl:param name="word" as="xs:string"/>
    <xsl:sequence select="matches($value, concat(concat('^(.*)', $word), '(.*)$'))"/>
  </xsl:function>


  <!-- ========================================================================
         function : Found 
		   ========================================================================
		   Description																																
		     This function will find the Argument as a word within the string. At the beginning, middle or end.
         This is a veneer of the functx:contains-word
		   ========================================================================																						
	       Input Parameters		
			  <xsl:param name="arg" as="xs:string"/>
			  <xsl:param name="word" as="xs:string"/>
		   ========================================================================
    	   Output 																																	
	 	      true if word is found in arg, false otherwise
		   ======================================================================== -->

  <xsl:function name="function:Found" as="xs:boolean">
    <xsl:param name="value" as="xs:string?"/>
    <xsl:param name="word" as="xs:string"/>
    <xsl:sequence select="matches(upper-case($value),concat('^(.*\W)?',upper-case(replace($word,'(\.|\[|\]|\\|\||\-|\^|\$|\?|\*|\+|\{|\}|\(|\))','\\$1')),'(\W.*)?$'))"/>
  </xsl:function>


  <!-- ========================================================================
           function : IsDate 
		   ========================================================================
		   Description																																
		     Thsi function make sure data a string can convert to date
		   ========================================================================																						
	       Input Parameters			
			   Input Parameters			
			  Date1
			  <xsl:param name="Date1" as="xs:anyAtomicType"/>
		   ========================================================================
    	   Output 																																	
	 	      true if input can cast to date , false otherwise
		   ======================================================================== -->

  <xsl:function name="function:IsDate" as="xs:boolean">
    <xsl:param name="Date1" as="xs:anyAtomicType?"/>
    <xsl:variable name="is-datecast" as="xs:boolean"
             select="$Date1 castable as xs:date"/>
    <xsl:sequence select= "$is-datecast"/>
  </xsl:function>

  <xsl:function name="function:DatetoSwsStr" as="xs:string">
    <xsl:param name="dateToconvert" as="xs:date"/>
    <xsl:sequence select= "format-date($dateToconvert, '[Y0001]-[M01]-[D01]')"/>
  </xsl:function>


  <!-- ========================================================================
           function : IsDate1GreaterOrEqualToDate2
		   ========================================================================
		   Description																																
		     This function compare Date1 and Date2
		   ========================================================================																						
	       Input Parameters			
			   Input Parameters			
			   Date1, Date2
			   <xsl:param name="Date1" as="xs:anyAtomicType"/>
                <xsl:param name="Date2" as="xs:anyAtomicType"/> 
		   ========================================================================
    	   Output : True 
           If Date1 and Date2 are Date
           and Date1>=Date2
           Otherwise out put false
	 	   
		   ======================================================================== -->

  <xsl:function name="function:IsDate1GreaterOrEqualToDate2" as="xs:boolean">
    <xsl:param name="Date1" as="xs:anyAtomicType?"/>
    <xsl:param name="Date2" as="xs:anyAtomicType?"/>
    <xsl:choose>
      <xsl:when test="function:IsDate($Date1) and function:IsDate($Date2)">
        <xsl:variable name="castedDate1" select="xs:date($Date1)" as="xs:date"/>
        <xsl:variable name="castedDate2" select="xs:date($Date2)" as="xs:date"/>
        <xsl:sequence select= "$castedDate1 >= $castedDate2"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <!-- ========================================================================
          function : IsDate1GreaterThanDate2
		   ========================================================================
		   Description																																
		     This function compare Date1 and Date2
		   ========================================================================																						
	       Input Parameters			
			   Input Parameters			
			   Date1, Date2
			   <xsl:param name="Date1" as="xs:anyAtomicType"/>
                <xsl:param name="Date2" as="xs:anyAtomicType"/> 
		   ========================================================================
    	   Output : True 
           If Date1 and Date2 are Date
           and Date1>Date2
           Otherwise output false
	 	   
		   ======================================================================== -->

  <xsl:function name="function:IsDate1GreaterThanDate2" as="xs:boolean">
    <xsl:param name="Date1" as="xs:anyAtomicType?"/>
    <xsl:param name="Date2" as="xs:anyAtomicType?"/>
    <xsl:choose>
      <xsl:when test="function:IsDate($Date1) and function:IsDate($Date2)">
        <xsl:variable name="castedDate1" select="xs:date($Date1)" as="xs:date"/>
        <xsl:variable name="castedDate2" select="xs:date($Date2)" as="xs:date"/>
        <xsl:sequence select= "$castedDate1 > $castedDate2"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>


  <!-- ========================================================================
          function : DaysFromDate1ToDate2
		   ========================================================================
		   Description																																
		     This returns the number of days between 2 dates
		   ========================================================================																						
	       Input Parameters			
			   Input Parameters			
			   Date1, Date2
			      <xsl:param name="Date1" as="xs:anyAtomicType"/>
            <xsl:param name="Date2" as="xs:anyAtomicType"/> 
		   ========================================================================
    	   Output : Number of days between dates
       ======================================================================== -->
  <xsl:function name="function:DaysFromDate1ToDate2" as="xs:integer">
    <xsl:param name="Date1" as="xs:anyAtomicType?"/>
    <xsl:param name="Date2" as="xs:anyAtomicType?"/>
    <xsl:choose>
      <xsl:when test="function:IsDate($Date1) and function:IsDate($Date2)">
        <xsl:variable name="castedDate1" select="xs:date($Date1)" as="xs:date"/>
        <xsl:variable name="castedDate2" select="xs:date($Date2)" as="xs:date"/>
        <xsl:sequence select="fn:days-from-duration($castedDate1 - $castedDate2)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>


  <xsl:function name="function:ValidateTAN" as="xs:boolean">
    <xsl:param name="TAN_Initial" as="xs:string"/>
    <xsl:variable name="TANNoSpace" select="translate($TAN_Initial,' ','')" as="xs:string"/>
    <xsl:variable name="TANNumberString" select=" string(number($TANNoSpace))" as="xs:string"/>
    <xsl:variable name="TANlength" select="string-length($TANNoSpace)" as="xs:integer"/>
    <xsl:variable name="TANWSum1" select=" 7*number(substring($TANNoSpace,1,1))" as="xs:double"/>
    <xsl:variable name="TANWSum2" select="9*number(substring($TANNoSpace,2,1)) " as="xs:double"/>
    <xsl:variable name="TANWSum3" select="8*number(substring($TANNoSpace,3,1))" as="xs:double"/>
    <xsl:variable name="TANWSum4" select="4*number(substring($TANNoSpace,4,1))" as="xs:double"/>
    <xsl:variable name="TANWSum5" select="6*number(substring($TANNoSpace,5,1))" as="xs:double"/>
    <xsl:variable name="TANWSum6" select="3*number(substring($TANNoSpace,6,1))" as="xs:double"/>
    <xsl:variable name="TANWSum7" select="5*number(substring($TANNoSpace,7,1)) " as="xs:double"/>
    <xsl:variable name="TANWSum8" select="1*number(substring($TANNoSpace,8,1))" as="xs:double"/>
    <xsl:variable name="SumTANWSum" select="$TANWSum1 + $TANWSum2 + $TANWSum3 + $TANWSum4 + $TANWSum5 + $TANWSum6 + $TANWSum7 + $TANWSum8" as="xs:double"/>
    <xsl:choose>
      <xsl:when test="($TANlength = 8) and ($SumTANWSum mod 11 ) = 0">
        <xsl:value-of  select= "true()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select= "false()"/>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:function>

  <!--ABN weighingFactors = { 10, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 };-->
  <xsl:function name="function:ValidateABN" as="xs:boolean">
    <xsl:param name="ABN_Initial" as="xs:string"/>
    <xsl:variable name="ABNNoSpace" select="translate($ABN_Initial,' ','')" as="xs:string"/>
    <xsl:variable name="ABNNumbeString" select=" string(number($ABNNoSpace))" as="xs:string"/>
    <xsl:variable name="ABNlength" select="string-length($ABNNoSpace)" as="xs:double"/>
    <xsl:variable name="ABNWSum1" select="10*(number(substring($ABNNoSpace,1,1))-1) " as="xs:double"/>
    <xsl:variable name="ABNWSum2" select="1*number(substring($ABNNoSpace,2,1)) " as="xs:double"/>
    <xsl:variable name="ABNWSum3" select="3*number(substring($ABNNoSpace,3,1))" as="xs:double"/>
    <xsl:variable name="ABNWSum4" select="5*number(substring($ABNNoSpace,4,1))" as="xs:double"/>
    <xsl:variable name="ABNWSum5" select=" 7*number(substring($ABNNoSpace,5,1))" as="xs:double"/>
    <xsl:variable name="ABNWSum6" select=" 9*number(substring($ABNNoSpace,6,1))" as="xs:double"/>
    <xsl:variable name="ABNWSum7" select="11*number(substring($ABNNoSpace,7,1)) " as="xs:double"/>
    <xsl:variable name="ABNWSum8" select="13*number(substring($ABNNoSpace,8,1))" as="xs:double"/>
    <xsl:variable name="ABNWSum9" select=" 15*number(substring($ABNNoSpace,9,1))" as="xs:double"/>
    <xsl:variable name="ABNWSum10" select="17*number(substring($ABNNoSpace,10,1)) " as="xs:double"/>
    <xsl:variable name="ABNWSum11" select="19*number(substring($ABNNoSpace,11,1))" as="xs:double"/>
    <xsl:variable name="SumABNWSum" select="$ABNWSum1 + $ABNWSum2 + $ABNWSum3 + $ABNWSum4 + $ABNWSum5 + $ABNWSum6 + $ABNWSum7 + $ABNWSum8 + $ABNWSum9 + $ABNWSum10 + $ABNWSum11" as="xs:double"/>
    <xsl:choose>
      <xsl:when test=" ($ABNlength = 11 ) and ($SumABNWSum mod 89 ) = 0 ">
        <xsl:value-of   select= "true()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select= "false()"/>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:function>

  <!--int checkDigit = Int32.Parse(cleanACN[8].ToString());
        ACN weighingFactors = { 8, 7, 6, 5, 4, 3, 2, 1 };
        int remainder = weightedSum % 10;
        return checkDigit == (10 - remainder) % 10;-->
  <xsl:function name="function:ValidateACN" as="xs:boolean">
    <xsl:param name="ACN_Initial" as="xs:string"/>
    <xsl:variable name="ACNNoSpace" select="translate($ACN_Initial,' ','')" as="xs:string"/>
    <xsl:variable name="ACNNumberString" select=" string(number($ACNNoSpace))" as="xs:string"/>

    <xsl:variable name="ACNLength" select="string-length($ACNNoSpace)" as="xs:double"/>
    <xsl:variable name="ACNWSum1" select="8*number(substring($ACNNoSpace,1,1)) " as="xs:double"/>
    <xsl:variable name="ACNWSum2" select="7*number(substring($ACNNoSpace,2,1))" as="xs:double"/>
    <xsl:variable name="ACNWSum3" select="6*number(substring($ACNNoSpace,3,1))" as="xs:double"/>
    <xsl:variable name="ACNWSum4" select="5*number(substring($ACNNoSpace,4,1))" as="xs:double"/>
    <xsl:variable name="ACNWSum5" select=" 4*number(substring($ACNNoSpace,5,1))" as="xs:double"/>
    <xsl:variable name="ACNWSum6" select="3*number(substring($ACNNoSpace,6,1)) " as="xs:double"/>
    <xsl:variable name="ACNWSum7" select="2*number(substring($ACNNoSpace,7,1))" as="xs:double"/>
    <xsl:variable name="ACNWSum8" select="1*number(substring($ACNNoSpace,8,1))" as="xs:double"/>
    <xsl:variable name="ACNcheckDigit" select="number(substring($ACNNoSpace,9,1))" as="xs:double"/>
    <xsl:variable name="SumACNWSum" select=" $ACNWSum1 + $ACNWSum2 + $ACNWSum3 + $ACNWSum4 + $ACNWSum5 + $ACNWSum6 + $ACNWSum7 + $ACNWSum8 " as="xs:double"/>
    <xsl:variable name="ACNremainder" select="$SumACNWSum mod 10 " as="xs:double"/>
    <xsl:choose>
      <xsl:when test=" ($ACNLength = 9) and ((10-$ACNremainder ) mod 10) = $ACNcheckDigit ">
        <xsl:value-of   select= "true()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select= "false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <!--TFN weighingFactors = { 1, 4, 3, 7, 5, 8, 6, 9, 10 };-->

  <xsl:function name="function:ValidateTFN" as="xs:boolean">
    <xsl:param name="TFN_Initial" as="xs:anyAtomicType"/>
    <xsl:choose>
      <xsl:when test="string-length($TFN_Initial) > 0">
        <xsl:variable name="TFNNoSpace" select="translate($TFN_Initial,' ','')" as="xs:string"/>
        <xsl:variable name="TFNNumberString" select="fn:replace($TFNNoSpace, '^0+', '' )" as="xs:string"/>
        <xsl:variable name="TFNlength" select="string-length($TFNNumberString)" as="xs:double"/>
        <xsl:variable name="TFNWSum1" select="1*number(substring($TFNNumberString,1,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum2" select="4*number(substring($TFNNumberString,2,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum3" select="3*number(substring($TFNNumberString,3,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum4" select="7*number(substring($TFNNumberString,4,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum5" select="5*number(substring($TFNNumberString,5,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum6" select="8*number(substring($TFNNumberString,6,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum7" select="6*number(substring($TFNNumberString,7,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum8" select="9*number(substring($TFNNumberString,8,1))" as="xs:double"/>
        <xsl:variable name="TFNWSum9" select="10*number(substring($TFNNumberString,9,1))" as="xs:double"/>
        <xsl:variable name="TFNLg8WSum8" select="0" as="xs:double"/>
        <xsl:variable name="TFNLg8WSum9" select="10*number(substring($TFNNumberString,8,1))" as="xs:double"/>
        <xsl:variable name="SumTFNLg8WSum" select="$TFNWSum1 + $TFNWSum2 + $TFNWSum3 + $TFNWSum4 + $TFNWSum5 + $TFNWSum6 + $TFNWSum7 + $TFNLg8WSum8 +$TFNLg8WSum9" as="xs:double"/>
        <xsl:variable name="SumTFNLg9WSum" select=" $TFNWSum1 + $TFNWSum2 + $TFNWSum3 + $TFNWSum4 + $TFNWSum5 + $TFNWSum6 + $TFNWSum7 + $TFNWSum8 +$TFNWSum9" as="xs:double"/>
        <xsl:choose>
          <xsl:when test=" ($TFNlength = 9 and ($SumTFNLg9WSum mod 11)=0 ) or ($TFNlength = 8 and ($SumTFNLg8WSum mod 11)=0 ) ">
            <xsl:value-of   select= "true()"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select= "false()"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <!-- ========================================================================
         function : GetCurrentFBTYear
		 ========================================================================
		 Description																																
		   This function get Current  FBT year
		 ========================================================================																						
	    Input Parameters			
			
		 ========================================================================
    	 Output : FBT Year
          	   
		 ======================================================================== -->

  <xsl:function name="function:GetCurrentFBTYear" as="xs:integer">
    <xsl:sequence select= "function:GetFBTYear(current-date())"/>
  </xsl:function>

  <!-- ========================================================================
         function : GetFBTYear
		 ========================================================================
		 Description																																
		   This function get FBT year
		 ========================================================================																						
	    Input Parameters			
			 Input Parameters			
			 Date1 as Date or string: anyAtomicType
			  <xsl:param name="Date1" as="xs:anyAtomicType"/>
		 ========================================================================
    	 Output : FBT Year
         If para pass in as a date -> Return FBTYear( If Month >3 then FBT Yr= Ry+1) else FBTYr=Year 
         If Para pass in  not a Date -> Return FBT Year =0
	 	   
		 ======================================================================== -->


  <xsl:function name="function:GetFBTYear" as="xs:integer">
    <xsl:param name="Date1" as="xs:anyAtomicType?"/>
    <xsl:variable name="fbtYear" select="0" as="xs:integer"/>
    <xsl:choose>
      <xsl:when test="function:IsDate($Date1) ">
        <xsl:variable name="castedDate1" select="xs:date($Date1)" as="xs:date"/>
        <xsl:sequence select="function:GetFBTYearFromDate($castedDate1)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select= "$fbtYear"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <!-- ========================================================================
         function : GetFBTYearFromDate
		 ========================================================================
		 Description																																
		   This function get FBT year
		 ========================================================================																						
	    Input Parameters			
			 Input Parameters			
			 Date1 as Date 
			  <xsl:param name="Date1" as="xs:date"/>
		 ========================================================================
    	 Output : FBT Year
         If para pass in as a date -> Return FBTYear( If Month >3 then FBT Yr= Ry+1) else FBTYr=Year 
         	   
		 ========================================================================
         -->

  <xsl:function name="function:GetFBTYearFromDate" as="xs:integer">
    <xsl:param name="Date1" as="xs:date"/>
    <xsl:variable name="fbtYear" select="0" as="xs:integer"/>
    <xsl:variable name="lyear" select="year-from-date($Date1)" as="xs:integer"/>
    <xsl:variable name="lmonth" select="month-from-date($Date1)" as="xs:integer"/>
    <xsl:choose>
      <xsl:when test=" $lmonth &gt; 3 ">
        <xsl:sequence select="$lyear+1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select= "$lyear"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <!-- ========================================================================
         matches replacement function
		 ========================================================================
		 Description																																
		   This function will emulate the current matches function, and will 
           adapt the EXSLT regular expressions for the XSLT2 matches function.
           This function is deprecated, and should not be used in new rules. The 
           XSLT2.0 matches function should be used instead.
           
           Be careful with the order of the regexs, as there are specific replaces 
           occuring before more general ones.
		 ========================================================================																						
	     Input Parameters			
			input - the string to be tested
            pattern - the EXSLT regular expression to test against
		 ========================================================================
    	 Output 																																	
	 	    true if input matches pattern, false otherwise
		 ======================================================================== -->
  <!--<xsl:function name="matches" as="xs:boolean">
        <xsl:param name="input" as="xs:string"/>
        <xsl:param name="pattern" as="xs:string"/>

        <xsl:variable name="adjustedPattern" as="xs:string" select="$pattern"/>

        -->
  <!-- replace \s with literal space character ' ' when in [] -->
  <!--
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '(\[.*?)(\\s)(.*?\])', '$1 $3')"/>

        -->
  <!-- replace \s with literal space character ' ' when in () -->
  <!--
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '(\(.*?)(\\s)(.*?\))', '$1 $3')"/>

        -->
  <!-- replace invalid "\/", "\ " escapes -->
  <!--
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '([^\\])\\/', '$1/' )"/>
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '\\ ', ' ' )"/>


        -->
  <!-- replace ignore case directives for now -->
  <!--
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '\(\?i\)', '' )"/>

        -->
  <!--
            Important: this regex must appear before the next one
            replace apostrophes with literal escaped apostrophes, e.g. \x27 -> ''; 
        -->
  <!--
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '\\x27', '''')"/>

        -->
  <!-- replace \xDD style character codes with &#xDD; style ones, e.g. \x23 -> &#x23; -->
  <!--
        <xsl:variable name="adjustedPattern" as="xs:string" select="replace($adjustedPattern, '\\(x[0-9]+)', '&amp;#$1;')"/>

        -->
  <!--<xsl:sequence select="matches($input, $adjustedPattern)"/>-->
  <!--
        <xsl:sequence select="matches($input, $adjustedPattern)"/>
    </xsl:function>-->


  <!-- ========================================================================
         function : AddRemoveYearsToDate
		   ========================================================================
		   Description																																
		     Adds the passed in number of years to the date passed in.  Has to check
         for leap years.  If the date passed in is the 29/02 must then ensure that
         the resultant date (date + years) is in fact valid. 
       
         eg.  Date            = 29/02/2040
              Years           = 60
              Resultant Date  = 29/02/2100
            
              However 29/02/2100 is NOT a valid date.  
            
              In this case, remove 1 day from the resultant date, therefore 
              returning 28/02/2100              
              
         The years passed in can be a positive or negative value.
		 ========================================================================																						
	      Input Parameters			
			     Date1 as Date, Years as Integer
			        <xsl:param name="Date" as="xs:date"/>
              <xsl:param name="Years" as="xs:integer"/>       
        
		 ========================================================================
    	 Output : The new date with the number of years added.                  	   
		 ========================================================================
  -->
  <xsl:function name="function:AddRemoveYearsToDate" as="xs:date?">
    <xsl:param name="Date" as="xs:string?"/>
    <xsl:param name="Years" as="xs:integer"/>

    <!--Check that the new date is actually valid-->
    <xsl:choose>
      <xsl:when test="function:IsDate($Date)">
        <!--Cast the string date to an xs:date-->
        <xsl:variable name="castedDate1" select="xs:date($Date)" as="xs:date"/>

        <!--Get the day and month as strings as no calculations are done on those-->
        <xsl:variable name="dayFromDate" select="function:Get2DigitValue(xs:string(day-from-date($castedDate1)))" as="xs:string"/>
        <xsl:variable name="monthFromDate" select="function:Get2DigitValue(xs:string(month-from-date($castedDate1)))" as="xs:string"/>

        <xsl:variable name="yearFromDate" select="year-from-date($castedDate1)" as="xs:integer"/>

        <!--Add the number of years-->
        <xsl:variable name="newYearFromDate" select="$yearFromDate + $Years" as="xs:integer"/>

        <!--Put the new date together-->
        <xsl:variable name="newDate" select="concat($newYearFromDate, '-', $monthFromDate, '-', $dayFromDate)" as="xs:string"/>

        <!--Check that the new date is actually valid-->
        <xsl:choose>
          <xsl:when test="function:IsDate($newDate)">
            <!--Date is fine so return it-->
            <xsl:sequence select="xs:date($newDate)"/>
          </xsl:when>
          <xsl:otherwise>
            <!--Date is invalid (leap year error) therefore set the day to the 28th February-->
            <xsl:sequence select="xs:date(concat($newYearFromDate, '-', $monthFromDate, '-28'))"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:function>


  <!-- ========================================================================
         function : Get2DigitValue
		   ========================================================================
		   Description																																
		     When passing in an integer value, checks to see if the length is 1, 
         if so adds a leading zero.
         
         Used mostly for date formatting when getting day-from-date and 
         month-from-date (which return a single digit)       
		 ========================================================================																						
	      Input Parameters			
			     value as string
			        <xsl:param name="value" as="xs:string"/>
        
		 ========================================================================
    	 Output : The 2 length representation of the value.                  	   
		 ========================================================================
  -->
  <xsl:function name="function:Get2DigitValue" as="xs:string">
    <xsl:param name="value" as="xs:string"/>
    <xsl:choose>
      <xsl:when test="fn:string-length($value) = 1">
        <xsl:sequence select="concat('0', $value)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="$value"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <!-- ========================================================================
         function : GetPositiveValue
		   ========================================================================
		   Description																																
		     When passing in an integer value, checks to see if the value is negative, 
         if so returns zero, otherwise returns the integer.
		 ========================================================================																						
	      Input Parameters			
			     value as string
			        <xsl:param name="value" as="xs:string"/>
        
		 ========================================================================
    	 Output : The passed in integer or zero, whichever is greater                  	   
		 ========================================================================
  -->
  <xsl:function name="function:GetPositiveValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="sum($value) >= 0">
        <xsl:sequence select="sum($value)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>


</xsl:stylesheet>